/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.contentassist;

import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.parsing.lexer.IRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class QuotedCompletionProposal
extends CommonCompletionProposal {
    private boolean addLeading;
    private boolean addTrailing;

    public QuotedCompletionProposal(String name, String description, String location, IRange range, Image image, Image[] userAgents) {
        this(name, description, location, range, image, userAgents, true, true);
    }

    public QuotedCompletionProposal(String name, String description, String location, IRange range, Image image, Image[] userAgents, boolean addleading, boolean addTrailing) {
        super(name, range.getStartingOffset(), range.getLength(), name.length(), image, name, null, description);
        this.setFileLocation(location);
        this.setUserAgentImages(userAgents);
        this.addLeading = addleading;
        this.addTrailing = addTrailing;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        block11: {
            try {
                IDocument document = viewer.getDocument();
                int prevChar = this._replacementOffset > 0 ? (int)document.getChar(this._replacementOffset - 1) : 32;
                char quote = '\"';
                switch (prevChar) {
                    case 39: {
                        quote = '\'';
                        break;
                    }
                    case 34: {
                        break;
                    }
                    default: {
                        if (!this.addLeading) break;
                        this._replacementString = "\"" + this._replacementString;
                        ++this._cursorPosition;
                    }
                }
                if (!this.addTrailing) break block11;
                int nextCharIndex = this._replacementOffset + this._replacementLength;
                if (nextCharIndex >= document.getLength()) {
                    this._replacementString = String.valueOf(this._replacementString) + quote;
                    ++this._cursorPosition;
                    break block11;
                }
                char nextChar = document.getChar(nextCharIndex);
                switch (nextChar) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this._replacementString = String.valueOf(this._replacementString) + quote;
                        ++this._cursorPosition;
                        break;
                    }
                    default: {
                        if (this.addEndQuote(nextChar)) {
                            this._replacementString = String.valueOf(this._replacementString) + quote + " ";
                            this._cursorPosition += 2;
                        }
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        super.apply(viewer, trigger, stateMask, offset);
    }

    protected boolean addEndQuote(char nextChar) {
        switch (nextChar) {
            case '\"': 
            case '\'': {
                return false;
            }
        }
        return true;
    }
}

